/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.Map;

public class UserManagerPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYUMPT";
    private static final String TRACE_MASKF = "XNTYUMPF";
    private static final String TRACE_MASKD = "XNTYUMPD";
    private transient ItemDescriptor[] m_idUserTable;
    private transient ColumnDescriptor[] m_cdUserTableStructure;
    private int[] m_iUserTableSelection;
    private Map data;
    public static final String USER_TABLE = "UserTable";
    public static final String TASKLET_SELECTED_USER = "TaskletSelectedUser";
    public static final String EDIT_MODE = "EditMode";

    public void setUserTableSelection(int[] selected) throws IllegalUserDataException {
        if (this.data.get(EDIT_MODE) != null && this.data.get(EDIT_MODE).equals(Boolean.TRUE)) {
            if (selected != null && selected.length > 0) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", true);
            } else {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
            }
        }
        this.m_iUserTableSelection = selected;
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "UserManagerPanel");
        String user = null;
        String[] users = null;
        Map[] usersMap = (Map[])this.data.get(USER_TABLE);
        if (this.m_iUserTableSelection != null && this.m_iUserTableSelection.length > 0) {
            users = new String[this.m_iUserTableSelection.length];
            int i = 0;
            while (i < this.m_iUserTableSelection.length) {
                users[i] = (String)usersMap[this.m_iUserTableSelection[i]].get("DataMapUserName");
                ++i;
            }
            user = users[0];
        } else {
            users = new String[]{};
        }
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setData(TASKLET_SELECTED_USER, users);
            request.setData("CommandName", "OKButton");
        } else if (command.equals(this.getMountPrefix() + "AddButton")) {
            request.setData("CommandName", "AddButton");
        } else if (command.equals(this.getMountPrefix() + "EditButton")) {
            request.setData("CommandName", "EditButton");
            request.setData(TASKLET_SELECTED_USER, user);
        } else if (command.equals(this.getMountPrefix() + "DeleteButton")) {
            request.setData("CommandName", "DeleteButton");
            request.setData(TASKLET_SELECTED_USER, user);
        }
        this.postTaskletRequest(request);
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object o) {
        Trace.trace(TRACE_MASKT, "<> update");
        if (o instanceof Map) {
            Map map = (Map)o;
            Map[] users = (Map[])this.data.get(USER_TABLE);
            String command = (String)map.get("CommandName");
            if (command.equals("DeleteButton")) {
                Map[] newUsers = new Map[users.length - 1];
                System.arraycopy(users, 0, newUsers, 0, this.m_iUserTableSelection[0]);
                System.arraycopy(users, this.m_iUserTableSelection[0] + 1, newUsers, this.m_iUserTableSelection[0], newUsers.length - this.m_iUserTableSelection[0]);
                this.data.put(USER_TABLE, newUsers);
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + USER_TABLE, new int[0]);
                this.setUserTableSelection(new int[0]);
            } else if (command.equals("AddButton")) {
                Map[] newUsers = new Map[users.length + 1];
                System.arraycopy(users, 0, newUsers, 0, users.length);
                HashMap newUser = new HashMap();
                newUser.put("DataMapUserName", map.get("DataMapUserName"));
                newUser.put("DataMapFullName", map.get("DataMapFullName"));
                newUser.put("DataMapOtherNotes", map.get("DataMapOtherNotes"));
                newUser.put("DataMapEnabled", map.get("DataMapEnabled"));
                newUsers[users.length] = newUser;
                this.data.put(USER_TABLE, newUsers);
            } else if (command.equals("EditButton")) {
                users[this.m_iUserTableSelection[0]].put("DataMapUserName", map.get("DataMapUserName"));
                users[this.m_iUserTableSelection[0]].put("DataMapFullName", map.get("DataMapFullName"));
                users[this.m_iUserTableSelection[0]].put("DataMapOtherNotes", map.get("DataMapOtherNotes"));
                users[this.m_iUserTableSelection[0]].put("DataMapEnabled", map.get("DataMapEnabled"));
            }
            this.userTaskManager.refreshAllElements();
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        int[] selectedUserIndicies = null;
        if (this.data == null) {
            this.data = new HashMap();
        } else {
            Boolean editMode;
            Map[] users = (Map[])this.data.get(USER_TABLE);
            String[] selectedUsers = (String[])this.data.get(TASKLET_SELECTED_USER);
            if (selectedUsers == null) {
                selectedUserIndicies = new int[]{};
                selectedUsers = new String[]{};
            } else {
                selectedUserIndicies = new int[selectedUsers.length];
            }
            boolean selectedUserIndex = false;
            if (users == null) {
                this.data.put(USER_TABLE, new Map[0]);
            }
            if ((editMode = (Boolean)this.data.get(EDIT_MODE)) == null) {
                editMode = Boolean.FALSE;
            }
            if (editMode.booleanValue()) {
                Trace.trace(TRACE_MASKF, "UserManagerPanelBean: edit mode");
                this.userTaskManager.setShown(this.getMountPrefix() + "OKButton", false);
                this.userTaskManager.setShown(this.getMountPrefix() + "CancelButton", false);
                this.userTaskManager.setShown(this.getMountPrefix() + "HelpButton", false);
                if (selectedUserIndicies == null || selectedUserIndicies.length == 0) {
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
                }
            } else {
                Trace.trace(TRACE_MASKF, "UserManagerPanelBean: non-edit mode");
                this.userTaskManager.setShown(this.getMountPrefix() + "AddButton", false);
                this.userTaskManager.setShown(this.getMountPrefix() + "EditButton", false);
                this.userTaskManager.setShown(this.getMountPrefix() + "DeleteButton", false);
            }
            if (selectedUserIndicies != null || selectedUserIndicies.length > 0) {
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + USER_TABLE, (int[])selectedUserIndicies.clone());
                this.m_iUserTableSelection = (int[])selectedUserIndicies.clone();
            }
        }
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        this.m_idUserTable = new ItemDescriptor[0];
        this.m_cdUserTableStructure = new ColumnDescriptor[0];
        this.m_iUserTableSelection = new int[0];
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getUserTableRowCount() {
        Map[] users = (Map[])this.data.get(USER_TABLE);
        return users.length;
    }

    public ItemDescriptor[] getUserTableRowAt(int index) {
        Map[] users = (Map[])this.data.get(USER_TABLE);
        ItemDescriptor col1 = new ItemDescriptor(this.getMountPrefix() + "userName_" + index, (String)users[index].get("DataMapUserName"));
        ItemDescriptor col2 = new ItemDescriptor(this.getMountPrefix() + "fullName_" + index, (String)users[index].get("DataMapFullName"));
        ItemDescriptor col3 = new ItemDescriptor(this.getMountPrefix() + "otherNotes_" + index, (String)users[index].get("DataMapOtherNotes"));
        ItemDescriptor col4 = new ItemDescriptor(this.getMountPrefix() + "enabled_" + index, ((Boolean)users[index].get("DataMapEnabled")).toString());
        ItemDescriptor[] row = new ItemDescriptor[]{col1, col2, col3, col4};
        return row;
    }

    public ColumnDescriptor[] getUserTableRowStructure() {
        return this.m_cdUserTableStructure;
    }

    public int getUserTableRowStatus() {
        return 3;
    }

    public void setUserTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idUserTable = items;
    }

    public int[] getUserTableSelection() {
        return this.m_iUserTableSelection;
    }
}

